﻿uses
  Common, DataEntry, DataStorage, DateUtils, PropertyList, SysUtils;

procedure OnStartFilter(aDataStore: TDataStore; Var DoContinue: boolean; Var OutObj: TObject);
var
  anEntryReader: TEntryReader;
begin
  anEntryReader := TEntryReader.Create;
  OutObj := anEntryReader;
end;

procedure OnEndFilter(Var OutObj: TObject);
begin
  if (OutObj <> nil) and (OutObj is TEntryReader) then
    OutObj.free;
end;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  aRootProperty: TPropertyNode;
  aPropertyTree: TPropertyParent;
  aExifNode: TPropertyNode;
  theFileDriverInfo: TFileTypeInformation;
  anEntryReader: TEntryReader;
begin
  if assigned(anEntry) then
  begin
    Result := -1; // Exclude

    anEntryReader := nil;
    if InObj is TEntryReader then
      anEntryReader := TEntryReader(InObj);

    if anEntryReader <> nil then
    begin
      theFileDriverInfo := anEntry.FileDriverInfo;
      if (theFileDriverInfo.ShortDisplayName <> null) and (trim(theFileDriverInfo.ShortDisplayName) <> '') then
      begin
        if dtGraphics in theFileDriverInfo.DriverType then
        begin
          if ProcessMetadataProperties(anEntry, aPropertyTree, anEntryReader) then
          begin
            if assigned(aPropertyTree) then
            begin
              aRootProperty := aPropertyTree;
              if assigned(aRootProperty) and assigned(aRootProperty.PropChildList) and (aRootProperty.PropChildList.Count > 0) then
              begin
                aExifNode := TPropertyNode(aRootProperty.GetFirstNodeByName('EXIF'));
                if assigned(aExifNode) then
                  Result := 1 // Include
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

function ScriptInformation: TScriptInformation; // [modARTIFACTS, modBOOKMARKS, modEMAIL, modFILESYSTEM, modKEYWORDSEARCH, modREGISTRY];
begin
  Result.Name := 'Graphics - EXIF Only';
  Result.Modules := [modBOOKMARKS, modEMAIL, modFILESYSTEM, modKEYWORDSEARCH];
end;

begin

end.
